/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class UpdateLaserColors
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "update_laser_colors");
    private List<BlockPos> positionsToUpdate;

    public UpdateLaserColors() {
    }

    public UpdateLaserColors(List<BlockPos> positionsToUpdate) {
        this.positionsToUpdate = positionsToUpdate;
    }

    public UpdateLaserColors(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        this.positionsToUpdate = new ArrayList<BlockPos>();
        for (int i = 0; i < size; ++i) {
            this.positionsToUpdate.add(BlockPos.of((long)buf.readLong()));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.positionsToUpdate.size());
        for (BlockPos pos : this.positionsToUpdate) {
            buf.writeLong(pos.asLong());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        for (BlockPos pos : this.positionsToUpdate) {
            ClientHandler.updateBlockColorAroundPosition(pos);
        }
    }
}

