/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class UpdateLogger
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "update_logger");
    private BlockPos pos;
    private int index;
    private String username;
    private String uuid;
    private long timestamp;

    public UpdateLogger() {
    }

    public UpdateLogger(BlockPos pos, int index, String username, String uuid, long timestamp) {
        this.pos = pos;
        this.index = index;
        this.username = username;
        this.uuid = uuid;
        this.timestamp = timestamp;
    }

    public UpdateLogger(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.index = buf.readInt();
        this.username = buf.readUtf(0x1FFFFFFF);
        this.uuid = buf.readUtf(0x1FFFFFFF);
        this.timestamp = buf.readLong();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.index);
        buf.writeUtf(this.username);
        buf.writeUtf(this.uuid);
        buf.writeLong(this.timestamp);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        UsernameLoggerBlockEntity be = (UsernameLoggerBlockEntity)Minecraft.getInstance().player.level().getBlockEntity(this.pos);
        if (be != null) {
            be.getPlayers()[this.index] = this.username;
            be.getUuids()[this.index] = this.uuid;
            be.getTimestamps()[this.index] = this.timestamp;
        }
    }
}

