/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class AssembleBlockPocket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "assemble_block_pocket");
    private BlockPos pos;
    private int size;

    public AssembleBlockPocket() {
    }

    public AssembleBlockPocket(BlockPocketManagerBlockEntity be) {
        this.pos = be.getBlockPos();
        this.size = be.getSize();
    }

    public AssembleBlockPocket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.size = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.size);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockPocketManagerBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof BlockPocketManagerBlockEntity && (be = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            be.setSize(this.size);
            MutableComponent feedback = be.autoAssembleMultiblock();
            be.setChanged();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).getDescriptionId(), new Object[0]), feedback, ChatFormatting.DARK_AQUA);
            }
        }
    }
}

