/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class CheckBriefcasePasscode
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "check_briefcase_passcode");
    private String passcode;

    public CheckBriefcasePasscode() {
    }

    public CheckBriefcasePasscode(String passcode) {
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckBriefcasePasscode(FriendlyByteBuf buf) {
        this.passcode = buf.readUtf();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.passcode);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get());
        if (!briefcase.isEmpty()) {
            if (PasscodeUtils.isOnCooldown(player)) {
                PlayerUtils.sendMessageToPlayer(player, Component.literal((String)"SecurityCraft"), Component.translatable((String)"messages.securitycraft:passcodeProtected.onCooldown"), ChatFormatting.RED);
                if (((Boolean)ConfigHandler.SERVER.passcodeSpamLogWarningEnabled.get()).booleanValue()) {
                    SecurityCraft.LOGGER.warn(String.format((String)ConfigHandler.SERVER.passcodeSpamLogWarning.get(), player.getGameProfile().getName(), ((BriefcaseItem)((Object)SCContent.BRIEFCASE.get())).getDescription().getString(), GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition())));
                }
                return;
            }
            CompoundTag tag = briefcase.getOrCreateTag();
            String tagCode = tag.getString("passcode");
            if (tagCode.length() == 4) {
                BriefcaseItem.hashAndSetPasscode(tag, PasscodeUtils.hashPasscodeWithoutSalt(tagCode), p -> BriefcaseItem.checkPasscode(player, briefcase, this.passcode, PasscodeUtils.bytesToString(p), tag));
            } else {
                BriefcaseItem.checkPasscode(player, briefcase, this.passcode, tagCode, tag);
            }
        }
    }
}

