/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Arrays;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class CheckPasscode
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "check_passcode");
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public CheckPasscode() {
    }

    public CheckPasscode(BlockPos pos, String passcode) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckPasscode(int entityId, String passcode) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckPasscode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.passcode = buf.readUtf(0x1FFFFFFF);
    }

    public void write(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeBlockPos(this.pos);
        } else {
            buf.writeVarInt(this.entityId);
        }
        buf.writeUtf(this.passcode);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(player.level());
        if (passcodeProtected != null) {
            if (PasscodeUtils.isOnCooldown(player)) {
                PlayerUtils.sendMessageToPlayer(player, Component.literal((String)"SecurityCraft"), Component.translatable((String)"messages.securitycraft:passcodeProtected.onCooldown"), ChatFormatting.RED);
                if (((Boolean)ConfigHandler.SERVER.passcodeSpamLogWarningEnabled.get()).booleanValue()) {
                    SecurityCraft.LOGGER.warn(this.formatForPasscodeProtected((String)ConfigHandler.SERVER.passcodeSpamLogWarning.get(), player, passcodeProtected));
                }
                return;
            }
            if (passcodeProtected.isOnCooldown()) {
                return;
            }
            PasscodeUtils.setOnCooldown(player);
            PasscodeUtils.hashPasscode(this.passcode, passcodeProtected.getSalt(), p -> {
                if (Arrays.equals(passcodeProtected.getPasscode(), p)) {
                    player.closeContainer();
                    passcodeProtected.activate(player);
                } else {
                    passcodeProtected.onIncorrectPasscodeEntered(player, this.passcode);
                }
            });
        }
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }

    private String formatForPasscodeProtected(String logMessage, Player player, IPasscodeProtected passcodeProtected) {
        Level level = player.level();
        BlockPos pos = BlockPos.ZERO;
        String name = "undefined";
        if (passcodeProtected instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)passcodeProtected;
            pos = be.getBlockPos();
            name = level.getBlockState(pos).getBlock().getName().getString();
        } else if (passcodeProtected instanceof Entity) {
            Entity entity = (Entity)passcodeProtected;
            pos = entity.blockPosition();
            name = entity.getType().getDescription().getString();
        }
        return String.format(logMessage, player.getGameProfile().getName(), name, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
    }
}

