/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MountCamera
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "mount_camera");
    private BlockPos pos;

    public MountCamera() {
    }

    public MountCamera(BlockPos pos) {
        this.pos = pos;
    }

    public MountCamera(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        BlockState state = level.getBlockState(this.pos);
        if (!player.isSpectator()) {
            SecurityCameraBlockEntity be;
            BlockEntity blockEntity;
            if (level.isLoaded(this.pos) && state.getBlock() == SCContent.SECURITY_CAMERA.get() && (blockEntity = level.getBlockEntity(this.pos)) instanceof SecurityCameraBlockEntity && !(be = (SecurityCameraBlockEntity)blockEntity).isDisabled() && !be.isShutDown()) {
                if (be.isOwnedBy((Entity)player) || be.isAllowed((Entity)player)) {
                    ((SecurityCameraBlock)state.getBlock()).mountCamera(level, this.pos, player);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", be.getOwner().getName()), ChatFormatting.RED);
                }
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", this.pos), ChatFormatting.RED);
            }
        }
    }
}

