/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.logging.log4j.util.TriConsumer;

public class RemoteControlMine
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "remote_control_mine");
    private BlockPos pos;
    private Action action;

    public RemoteControlMine() {
    }

    public RemoteControlMine(BlockPos pos, Action action) {
        this.pos = pos;
        this.action = action;
    }

    public RemoteControlMine(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.action = (Action)buf.readEnum(Action.class);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.action);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Block block;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        BlockState state = level.getBlockState(this.pos);
        if (!player.isSpectator() && (block = state.getBlock()) instanceof IExplosive) {
            IOwnable be;
            IExplosive explosive = (IExplosive)block;
            block = level.getBlockEntity(this.pos);
            if (block instanceof IOwnable && (be = (IOwnable)block).isOwnedBy((Entity)player)) {
                this.action.act(explosive, level, this.pos);
            }
        }
    }

    public static enum Action {
        ACTIVATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::activateMine)),
        DEFUSE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::defuseMine)),
        DETONATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::explode));

        private final TriConsumer<IExplosive, Level, BlockPos> action;

        private Action(TriConsumer<IExplosive, Level, BlockPos> action) {
            this.action = action;
        }

        public void act(IExplosive explosive, Level level, BlockPos pos) {
            this.action.accept((Object)explosive, (Object)level, (Object)pos);
        }
    }
}

