/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class RemoveCameraTag
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "remove_camera_tag");
    private int camID;

    public RemoveCameraTag() {
    }

    public RemoveCameraTag(int cid) {
        this.camID = cid;
    }

    public RemoveCameraTag(FriendlyByteBuf buf) {
        this.camID = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.camID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack monitor = PlayerUtils.getItemStackFromAnyHand((Player)ctx.player().orElseThrow(), (Item)SCContent.CAMERA_MONITOR.get());
        if (!player.isSpectator() && !monitor.isEmpty() && monitor.hasTag()) {
            monitor.getTag().remove(CameraMonitorItem.getTagNameFromPosition(monitor.getTag(), (GlobalPos)CameraMonitorItem.getCameraPositions(monitor.getTag()).get(this.camID - 1).getLeft()));
        }
    }
}

