/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class RemoveMineFromMRAT
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "remove_mine_from_mrat");
    private int mineIndex;

    public RemoveMineFromMRAT() {
    }

    public RemoveMineFromMRAT(int mineIndex) {
        this.mineIndex = mineIndex;
    }

    public RemoveMineFromMRAT(FriendlyByteBuf buf) {
        this.mineIndex = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.mineIndex);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        CompoundTag tag;
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get());
        if (!player.isSpectator() && !stack.isEmpty() && (tag = stack.getOrCreateTag()).contains("mine" + this.mineIndex)) {
            tag.remove("mine" + this.mineIndex);
        }
    }
}

