/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class RemoveSentryFromSRAT
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "remove_sentry_from_srat");
    private int sentryIndex;

    public RemoveSentryFromSRAT() {
    }

    public RemoveSentryFromSRAT(int mineIndex) {
        this.sentryIndex = mineIndex;
    }

    public RemoveSentryFromSRAT(FriendlyByteBuf buf) {
        this.sentryIndex = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.sentryIndex);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        CompoundTag tag;
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
        if (!player.isSpectator() && !stack.isEmpty() && (tag = stack.getOrCreateTag()).contains("sentry" + this.sentryIndex)) {
            tag.remove("sentry" + this.sentryIndex);
        }
    }
}

