/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetBriefcasePasscodeAndOwner
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_briefcase_passcode_and_owner");
    private String passcode;

    public SetBriefcasePasscodeAndOwner() {
    }

    public SetBriefcasePasscodeAndOwner(String passcode) {
        this.passcode = passcode.isEmpty() ? passcode : PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public SetBriefcasePasscodeAndOwner(FriendlyByteBuf buf) {
        this.passcode = buf.readUtf();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.passcode);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get());
        if (!player.isSpectator() && !stack.isEmpty()) {
            CompoundTag tag = stack.getOrCreateTag();
            if (!tag.contains("owner")) {
                tag.putString("owner", player.getName().getString());
                tag.putString("ownerUUID", player.getUUID().toString());
            }
            if (!this.passcode.isEmpty() && !tag.contains("passcode")) {
                BriefcaseItem.hashAndSetPasscode(tag, this.passcode, p -> PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new OpenScreen(OpenScreen.DataType.CHECK_PASSCODE_FOR_BRIEFCASE)}));
            }
        }
    }
}

