/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetCameraPowered
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_camera_powered");
    private BlockPos pos;
    private boolean powered;

    public SetCameraPowered() {
    }

    public SetCameraPowered(BlockPos pos, boolean powered) {
        this.pos = pos;
        this.powered = powered;
    }

    public SetCameraPowered(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.powered = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.powered);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        IModuleInventory moduleInv;
        IOwnable ownable;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        BlockEntity be = level.getBlockEntity(this.pos);
        if (!player.isSpectator() && be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isAllowed((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            level.setBlockAndUpdate(this.pos, (BlockState)state.setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
            level.updateNeighborsAt(this.pos.relative((Direction)state.getValue((Property)SecurityCameraBlock.FACING), -1), state.getBlock());
        }
    }
}

