/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetDefaultCameraViewingDirection
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_default_camera_viewing_direction");
    private int id;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom;

    public SetDefaultCameraViewingDirection() {
    }

    public SetDefaultCameraViewingDirection(SecurityCamera cam) {
        this.id = cam.getId();
        this.initialXRotation = cam.getXRot();
        this.initialYRotation = cam.getYRot();
        this.initialZoom = cam.getZoomAmount();
    }

    public SetDefaultCameraViewingDirection(FriendlyByteBuf buf) {
        this.id = buf.readVarInt();
        this.initialXRotation = buf.readFloat();
        this.initialYRotation = buf.readFloat();
        this.initialZoom = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.id);
        buf.writeFloat(this.initialXRotation);
        buf.writeFloat(this.initialYRotation);
        buf.writeFloat(this.initialZoom);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        SecurityCamera camera;
        Entity entity;
        ServerPlayer player = (ServerPlayer)ctx.player().orElseThrow();
        if (!player.isSpectator() && (entity = player.getCamera()) instanceof SecurityCamera && (camera = (SecurityCamera)entity).getId() == this.id && (entity = camera.level().getBlockEntity(camera.blockPosition())) instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)entity;
            if (!be.isOwnedBy((Entity)player)) {
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.no_permission", new Object[0]), true);
                return;
            }
            if (be.isModuleEnabled(ModuleType.SMART)) {
                be.setDefaultViewingDirection(this.initialXRotation, this.initialYRotation, this.initialZoom);
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.direction_set", new Object[0]), true);
            } else {
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.smart_module_needed", new Object[0]), true);
            }
        }
    }
}

