/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetGhostSlot
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_ghost_slot");
    private int slotIndex;
    private ItemStack stack;

    public SetGhostSlot() {
    }

    public SetGhostSlot(int slot, ItemStack stack) {
        this.slotIndex = slot;
        this.stack = stack;
    }

    public SetGhostSlot(FriendlyByteBuf buf) {
        this.slotIndex = buf.readVarInt();
        this.stack = buf.readItem();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.slotIndex);
        buf.writeItem(this.stack);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        AbstractContainerMenu abstractContainerMenu;
        Player player = (Player)ctx.player().orElseThrow();
        if (!player.isSpectator() && (abstractContainerMenu = player.containerMenu) instanceof InventoryScannerMenu) {
            InventoryScannerMenu menu = (InventoryScannerMenu)abstractContainerMenu;
            if (menu.be.isOwnedBy((Entity)player)) {
                menu.be.getContents().set(this.slotIndex, (Object)this.stack);
            }
        }
    }
}

