/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetKeycardUses
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_keycard_uses");
    private BlockPos pos;
    private int uses;

    public SetKeycardUses() {
    }

    public SetKeycardUses(BlockPos pos, int uses) {
        this.pos = pos;
        this.uses = uses;
    }

    public SetKeycardUses(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.uses = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.uses);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        KeycardReaderBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof KeycardReaderBlockEntity && ((be = (KeycardReaderBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player)) && (blockEntity = player.containerMenu) instanceof KeycardReaderMenu) {
            KeycardReaderMenu keycardReaderContainer = (KeycardReaderMenu)blockEntity;
            keycardReaderContainer.setKeycardUses(this.uses);
        }
    }
}

