/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetListModuleData
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_list_module_data");
    private CompoundTag tag;

    public SetListModuleData() {
    }

    public SetListModuleData(CompoundTag tag) {
        this.tag = tag;
    }

    public SetListModuleData(FriendlyByteBuf buf) {
        this.tag = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.ALLOWLIST_MODULE.get());
        if (stack.isEmpty()) {
            stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.DENYLIST_MODULE.get());
        }
        if (!player.isSpectator() && !stack.isEmpty()) {
            CompoundTag clientTag = this.tag;
            CompoundTag serverTag = stack.getOrCreateTag();
            for (int i = 1; i <= 50; ++i) {
                String key = "Player" + i;
                if (clientTag.contains(key)) {
                    serverTag.putString(key, clientTag.getString(key));
                    continue;
                }
                serverTag.remove(key);
            }
            if (clientTag.contains("ListedTeams")) {
                ListTag listedTeams = new ListTag();
                for (Tag teamTag : clientTag.getList("ListedTeams", 8)) {
                    if (!player.getScoreboard().getTeamNames().contains(teamTag.getAsString())) continue;
                    listedTeams.add((Object)teamTag);
                }
                serverTag.put("ListedTeams", (Tag)listedTeams);
            }
            serverTag.putBoolean("affectEveryone", clientTag.getBoolean("affectEveryone"));
        }
    }
}

