/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SetPasscode
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_passcode");
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public SetPasscode() {
    }

    public SetPasscode(BlockPos pos, String code) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(int entityId, String code) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.passcode = buf.readUtf(0x1FFFFFFF);
    }

    public void write(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeBlockPos(this.pos);
        } else {
            buf.writeVarInt(this.entityId);
        }
        buf.writeUtf(this.passcode);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        IOwnable ownable;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(level);
        if (!(player.isSpectator() || passcodeProtected == null || passcodeProtected instanceof IOwnable && !(ownable = (IOwnable)((Object)passcodeProtected)).isOwnedBy((Entity)player))) {
            passcodeProtected.hashAndSetPasscode(this.passcode, b -> passcodeProtected.openPasscodeGUI(level, this.pos, player));
            passcodeProtected.setPasscodeInAdjacentBlock(this.passcode);
        }
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }
}

