/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.GameData;

public class SetStateOnDisguiseModule
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "set_state_on_disguise_module");
    private BlockState state;
    private StandingOrWallType standingOrWall;

    public SetStateOnDisguiseModule() {
    }

    public SetStateOnDisguiseModule(BlockState state, StandingOrWallType standingOrWall) {
        this.state = state;
        this.standingOrWall = standingOrWall;
    }

    public SetStateOnDisguiseModule(FriendlyByteBuf buf) {
        this.state = (BlockState)GameData.getBlockStateIDMap().byId(buf.readInt());
        this.standingOrWall = (StandingOrWallType)buf.readEnum(StandingOrWallType.class);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(GameData.getBlockStateIDMap().getId((Object)this.state));
        buf.writeEnum((Enum)this.standingOrWall);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        Player player = (Player)ctx.player().orElseThrow();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.DISGUISE_MODULE.get());
        if (!player.isSpectator() && !stack.isEmpty()) {
            CompoundTag tag = stack.getOrCreateTag();
            if (this.state.isAir()) {
                tag.remove("SavedState");
                tag.remove("StandingOrWall");
                tag.remove("ItemInventory");
            } else {
                tag.put("SavedState", (Tag)NbtUtils.writeBlockState((BlockState)this.state));
                tag.putInt("StandingOrWall", this.standingOrWall.ordinal());
            }
        }
    }
}

