/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncAlarmSettings
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_alarm_settings");
    private BlockPos pos;
    private ResourceLocation soundEvent;
    private float pitch;
    private int soundLength;

    public SyncAlarmSettings() {
    }

    public SyncAlarmSettings(BlockPos pos, ResourceLocation soundEvent, float pitch, int soundLength) {
        this.pos = pos;
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.soundLength = soundLength;
    }

    public SyncAlarmSettings(FriendlyByteBuf buf) {
        this.pos = BlockPos.of((long)buf.readLong());
        this.soundEvent = buf.readResourceLocation();
        this.pitch = buf.readFloat();
        this.soundLength = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.asLong());
        buf.writeResourceLocation(this.soundEvent);
        buf.writeFloat(this.pitch);
        buf.writeVarInt(this.soundLength);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        AlarmBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!this.soundEvent.equals((Object)be.getSound().getLocation())) {
                be.setSound(this.soundEvent);
            }
            if (this.pitch != be.getPitch()) {
                be.setPitch(this.pitch);
            }
            if (this.soundLength != be.getSoundLength()) {
                be.setSoundLength(this.soundLength);
            }
        }
    }
}

