/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncBlockChangeDetector
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_block_change_detector");
    private BlockPos pos;
    private BlockChangeDetectorBlockEntity.DetectionMode mode;
    private boolean showHighlights;
    private int color;

    public SyncBlockChangeDetector() {
    }

    public SyncBlockChangeDetector(BlockPos pos, BlockChangeDetectorBlockEntity.DetectionMode mode, boolean showHighlights, int color) {
        this.pos = pos;
        this.mode = mode;
        this.showHighlights = showHighlights;
        this.color = color;
    }

    public SyncBlockChangeDetector(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.mode = (BlockChangeDetectorBlockEntity.DetectionMode)buf.readEnum(BlockChangeDetectorBlockEntity.DetectionMode.class);
        this.showHighlights = buf.readBoolean();
        this.color = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.mode);
        buf.writeBoolean(this.showHighlights);
        buf.writeInt(this.color);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockChangeDetectorBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof BlockChangeDetectorBlockEntity && (be = (BlockChangeDetectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.setMode(this.mode);
            be.showHighlights(this.showHighlights);
            be.setColor(this.color);
            be.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

