/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncBlockPocketManager
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_block_pocket_manager");
    private BlockPos pos;
    private int size;
    private boolean showOutline;
    private int autoBuildOffset;
    private int color;

    public SyncBlockPocketManager() {
    }

    public SyncBlockPocketManager(BlockPos pos, int size, boolean showOutline, int autoBuildOffset, int color) {
        this.pos = pos;
        this.size = size;
        this.showOutline = showOutline;
        this.autoBuildOffset = autoBuildOffset;
        this.color = color;
    }

    public SyncBlockPocketManager(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.size = buf.readVarInt();
        this.showOutline = buf.readBoolean();
        this.autoBuildOffset = buf.readVarInt();
        this.color = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.size);
        buf.writeBoolean(this.showOutline);
        buf.writeVarInt(this.autoBuildOffset);
        buf.writeInt(this.color);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockPocketManagerBlockEntity bpm;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && level.isLoaded(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof BlockPocketManagerBlockEntity && (bpm = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            bpm.setSize(this.size);
            bpm.setShowOutline(this.showOutline);
            bpm.setAutoBuildOffset(this.autoBuildOffset);
            bpm.setColor(this.color);
            bpm.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

