/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncBlockReinforcer
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_block_reinforcer");
    private boolean isReinforcing;

    public SyncBlockReinforcer() {
    }

    public SyncBlockReinforcer(boolean isReinforcing) {
        this.isReinforcing = isReinforcing;
    }

    public SyncBlockReinforcer(FriendlyByteBuf buf) {
        this.isReinforcing = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isReinforcing);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ItemStack reinforcer;
        Player player = (Player)ctx.player().orElseThrow();
        Inventory inventory = player.getInventory();
        ItemStack itemStack = reinforcer = inventory.getSelected().getItem() instanceof UniversalBlockReinforcerItem ? inventory.getSelected() : (ItemStack)inventory.offhand.get(0);
        if (!reinforcer.isEmpty() && !reinforcer.is((Item)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get())) {
            reinforcer.getOrCreateTag().putBoolean("is_unreinforcing", !this.isReinforcing);
        }
    }
}

