/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Optional;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncFrame
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_frame");
    private BlockPos pos;
    private int requestedRenderDistance;
    private Optional<GlobalPos> removedCamera;
    private Optional<GlobalPos> currentCamera;
    boolean disableCurrentCamera;

    public SyncFrame() {
    }

    public SyncFrame(BlockPos pos, int requestedRenderDistance, Optional<GlobalPos> removedCamera, Optional<GlobalPos> currentCamera, boolean disableCurrentCamera) {
        this.pos = pos;
        this.requestedRenderDistance = requestedRenderDistance;
        this.removedCamera = removedCamera;
        this.currentCamera = currentCamera;
        this.disableCurrentCamera = disableCurrentCamera;
    }

    public SyncFrame(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.requestedRenderDistance = buf.readVarInt();
        this.removedCamera = buf.readOptional(FriendlyByteBuf::readGlobalPos);
        this.currentCamera = buf.readOptional(FriendlyByteBuf::readGlobalPos);
        this.disableCurrentCamera = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.requestedRenderDistance);
        buf.writeOptional(this.removedCamera, FriendlyByteBuf::writeGlobalPos);
        buf.writeOptional(this.currentCamera, FriendlyByteBuf::writeGlobalPos);
        buf.writeBoolean(this.disableCurrentCamera);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(IPayloadContext ctx) {
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        GlobalPos currentCamera = this.currentCamera.orElse(null);
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (be.isDisabled()) {
                return;
            }
            boolean isOwner = be.isOwnedBy((Entity)player);
            if (isOwner) {
                this.removedCamera.ifPresent(be::removeCamera);
            }
            if (isOwner || be.isAllowed((Entity)player)) {
                be.switchCameraOnServer(currentCamera, player, this.requestedRenderDistance, this.disableCurrentCamera);
            }
        }
    }
}

