/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncKeycardSettings
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_keycard_settings");
    private BlockPos pos;
    private int signature;
    private boolean[] acceptedLevels;
    private boolean link;
    private String usableBy;

    public SyncKeycardSettings() {
    }

    public SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link, String usableBy) {
        this.pos = pos;
        this.acceptedLevels = acceptedLevels;
        this.signature = signature;
        this.link = link;
        this.usableBy = usableBy;
    }

    public SyncKeycardSettings(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.signature = buf.readVarInt();
        this.link = buf.readBoolean();
        this.acceptedLevels = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.acceptedLevels[i] = buf.readBoolean();
        }
        this.usableBy = buf.readUtf();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.signature);
        buf.writeBoolean(this.link);
        for (int i = 0; i < 5; ++i) {
            buf.writeBoolean(this.acceptedLevels[i]);
        }
        buf.writeUtf(this.usableBy);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        KeycardReaderBlockEntity be;
        boolean isOwner;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof KeycardReaderBlockEntity && ((isOwner = (be = (KeycardReaderBlockEntity)blockEntity).isOwnedBy((Entity)player)) || be.isAllowed((Entity)player))) {
            AbstractContainerMenu abstractContainerMenu;
            if (isOwner) {
                be.setAcceptedLevels(this.acceptedLevels);
                be.setSignature(this.signature);
            }
            if (this.link && (abstractContainerMenu = player.containerMenu) instanceof KeycardReaderMenu) {
                KeycardReaderMenu keycardReaderContainer = (KeycardReaderMenu)abstractContainerMenu;
                keycardReaderContainer.link(this.usableBy);
            }
        }
    }
}

