/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Map;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncLaserSideConfig
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_laser_side_config");
    private BlockPos pos;
    private CompoundTag sideConfig;

    public SyncLaserSideConfig() {
    }

    public SyncLaserSideConfig(BlockPos pos, Map<Direction, Boolean> sideConfig) {
        this.pos = pos;
        this.sideConfig = LaserBlockBlockEntity.saveSideConfig(sideConfig);
    }

    public SyncLaserSideConfig(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.sideConfig = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.sideConfig);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        LaserBlockBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.applyNewSideConfig(LaserBlockBlockEntity.loadSideConfig(this.sideConfig), player);
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

