/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncProjector
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_projector");
    private BlockPos pos;
    private int data;
    private DataType dataType;

    public SyncProjector() {
    }

    public SyncProjector(BlockPos pos, int data, DataType dataType) {
        this.pos = pos;
        this.data = data;
        this.dataType = dataType;
    }

    public SyncProjector(BlockPos pos, BlockState state) {
        this.pos = pos;
        this.data = Block.getId((BlockState)state);
        this.dataType = DataType.BLOCK_STATE;
    }

    public SyncProjector(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dataType = (DataType)buf.readEnum(DataType.class);
        this.data = this.dataType.isBoolean ? (buf.readBoolean() ? 1 : 0) : buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.dataType);
        if (this.dataType.isBoolean) {
            buf.writeBoolean(this.data == 1);
        } else {
            buf.writeVarInt(this.data);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && level.isLoaded(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            switch (this.dataType) {
                case WIDTH: {
                    be.setProjectionWidth(this.data);
                    break;
                }
                case HEIGHT: {
                    be.setProjectionHeight(this.data);
                    break;
                }
                case RANGE: {
                    be.setProjectionRange(this.data);
                    break;
                }
                case OFFSET: {
                    be.setProjectionOffset(this.data);
                    break;
                }
                case HORIZONTAL: {
                    be.setHorizontal(this.data == 1);
                    break;
                }
                case OVERRIDING_BLOCKS: {
                    be.setOverridingBlocks(this.data == 1);
                    break;
                }
                case BLOCK_STATE: {
                    be.setProjectedState(Block.stateById((int)this.data));
                    break;
                }
            }
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL(true),
        OVERRIDING_BLOCKS(true),
        BLOCK_STATE,
        INVALID;

        public final boolean isBoolean;

        private DataType() {
            this(false);
        }

        private DataType(boolean isBoolean) {
            this.isBoolean = isBoolean;
        }
    }
}

