/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncRiftStabilizer
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_rift_stabilizer");
    private BlockPos pos;
    private RiftStabilizerBlockEntity.TeleportationType teleportationType;
    private boolean allowed;

    public SyncRiftStabilizer() {
    }

    public SyncRiftStabilizer(BlockPos pos, RiftStabilizerBlockEntity.TeleportationType teleportationType, boolean allowed) {
        this.pos = pos;
        this.teleportationType = teleportationType;
        this.allowed = allowed;
    }

    public SyncRiftStabilizer(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.teleportationType = (RiftStabilizerBlockEntity.TeleportationType)buf.readEnum(RiftStabilizerBlockEntity.TeleportationType.class);
        this.allowed = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.teleportationType);
        buf.writeBoolean(this.allowed);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        if (this.teleportationType != null) {
            RiftStabilizerBlockEntity be;
            BlockEntity blockEntity;
            Player player = (Player)ctx.player().orElseThrow();
            Level level = player.level();
            if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
                BlockState state = level.getBlockState(this.pos);
                be.setFilter(this.teleportationType, this.allowed);
                level.sendBlockUpdated(this.pos, state, state, 2);
            }
        }
    }
}

