/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncSSSSettingsOnServer
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_sss_settings_on_server");
    private BlockPos pos;
    private DataType dataType;
    private BlockPos posToRemove;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this(pos, dataType, null);
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType, BlockPos posToRemove) {
        this.pos = pos;
        this.dataType = dataType;
        this.posToRemove = posToRemove;
    }

    public SyncSSSSettingsOnServer(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dataType = (DataType)buf.readEnum(DataType.class);
        if (this.dataType == DataType.REMOVE_POS) {
            this.posToRemove = buf.readBlockPos();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.dataType);
        if (this.dataType == DataType.REMOVE_POS) {
            buf.writeBlockPos(this.posToRemove);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            switch (this.dataType) {
                case POWER_ON: {
                    sss.setActive(true);
                    break;
                }
                case POWER_OFF: {
                    sss.setActive(false);
                    if (!sss.isRecording()) break;
                    sss.setRecording(false);
                    break;
                }
                case SOUND_ON: {
                    sss.setPings(true);
                    break;
                }
                case SOUND_OFF: {
                    sss.setPings(false);
                    break;
                }
                case RECORDING_ON: {
                    sss.setRecording(true);
                    break;
                }
                case RECORDING_OFF: {
                    sss.setRecording(false);
                    break;
                }
                case CLEAR_NOTES: {
                    sss.clearNotes();
                    break;
                }
                case REMOVE_POS: {
                    sss.delink(this.posToRemove, false);
                    break;
                }
                case INVERT_FUNCTIONALITY: {
                    sss.setDisableBlocksWhenTuneIsPlayed(!sss.disablesBlocksWhenTuneIsPlayed());
                }
            }
            sss.setChanged();
        }
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES,
        REMOVE_POS,
        INVERT_FUNCTIONALITY;

    }
}

