/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncSecureRedstoneInterface
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_secure_redstone_interface");
    private BlockPos pos;
    private boolean sender;
    private boolean protectedSignal;
    private int frequency;
    private boolean sendExactPower;
    private boolean receiveInvertedPower;
    private int senderRange;
    private boolean highlightConnections;

    public SyncSecureRedstoneInterface(BlockPos pos, boolean sender, boolean protectedSignal, int frequency, boolean sendExactPower, boolean receiveInvertedPower, int senderRange, boolean highlightConnections) {
        this.pos = pos;
        this.sender = sender;
        this.protectedSignal = protectedSignal;
        this.frequency = frequency;
        this.sendExactPower = sendExactPower;
        this.receiveInvertedPower = receiveInvertedPower;
        this.senderRange = senderRange;
        this.highlightConnections = highlightConnections;
    }

    public SyncSecureRedstoneInterface(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.sender = buf.readBoolean();
        this.protectedSignal = buf.readBoolean();
        this.frequency = buf.readVarInt();
        this.sendExactPower = buf.readBoolean();
        this.receiveInvertedPower = buf.readBoolean();
        this.senderRange = buf.readVarInt();
        this.highlightConnections = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.sender);
        buf.writeBoolean(this.protectedSignal);
        buf.writeVarInt(this.frequency);
        buf.writeBoolean(this.sendExactPower);
        buf.writeBoolean(this.receiveInvertedPower);
        buf.writeVarInt(this.senderRange);
        buf.writeBoolean(this.highlightConnections);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(IPayloadContext ctx) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (this.sender != be.isSender()) {
                be.setSender(this.sender);
            }
            if (this.protectedSignal != be.isProtectedSignal()) {
                be.setProtectedSignal(this.protectedSignal);
            }
            if (this.frequency != be.getFrequency()) {
                be.setFrequency(this.frequency);
            }
            if (this.sendExactPower != be.sendsExactPower()) {
                be.setSendExactPower(this.sendExactPower);
            }
            if (this.receiveInvertedPower != be.receivesInvertedPower()) {
                be.setReceiveInvertedPower(this.receiveInvertedPower);
            }
            if (this.senderRange != be.getSenderRange()) {
                be.setSenderRange(this.senderRange);
            }
            be.setHighlightConnections(this.highlightConnections);
        }
    }
}

