/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncTrophySystem
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "sync_trophy_system");
    private BlockPos pos;
    private ResourceLocation projectileTypeLocation;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityType<?> projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileTypeLocation = Utils.getRegistryName(projectileType);
        this.allowed = allowed;
    }

    public SyncTrophySystem(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.projectileTypeLocation = buf.readResourceLocation();
        this.allowed = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeResourceLocation(this.projectileTypeLocation);
        buf.writeBoolean(this.allowed);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        TrophySystemBlockEntity be;
        BlockEntity blockEntity;
        EntityType projectileType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.projectileTypeLocation);
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.setFilter(projectileType, this.allowed);
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

