/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ToggleBlockPocketManager
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "toggle_block_pocket_manager");
    private BlockPos pos;
    private int size;
    private boolean enabling;

    public ToggleBlockPocketManager() {
    }

    public ToggleBlockPocketManager(BlockPocketManagerBlockEntity be, boolean enabling) {
        this.pos = be.getBlockPos();
        this.size = be.getSize();
        this.enabling = enabling;
    }

    public ToggleBlockPocketManager(FriendlyByteBuf buf) {
        this.pos = BlockPos.of((long)buf.readLong());
        this.size = buf.readInt();
        this.enabling = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.asLong());
        buf.writeInt(this.size);
        buf.writeBoolean(this.enabling);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        BlockPocketManagerBlockEntity be;
        BlockEntity blockEntity;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof BlockPocketManagerBlockEntity && (be = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = be.getBlockState();
            be.setSize(this.size);
            MutableComponent feedback = this.enabling ? be.enableMultiblock() : be.disableMultiblock();
            if (feedback != null) {
                if (this.enabling && !be.isEnabled()) {
                    ctx.replyHandler().send((CustomPacketPayload)new BlockPocketManagerFailedActivation(this.pos));
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).getDescriptionId(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, false);
            }
            be.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

