/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ToggleModule
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "toggle_module");
    private BlockPos pos;
    private ModuleType moduleType;
    private int entityId;

    public ToggleModule() {
    }

    public ToggleModule(BlockPos pos, ModuleType moduleType) {
        this.pos = pos;
        this.moduleType = moduleType;
    }

    public ToggleModule(int entityId, ModuleType moduleType) {
        this.entityId = entityId;
        this.moduleType = moduleType;
    }

    public ToggleModule(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.moduleType = (ModuleType)buf.readEnum(ModuleType.class);
    }

    public void write(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeBlockPos(this.pos);
        } else {
            buf.writeVarInt(this.entityId);
        }
        buf.writeEnum((Enum)this.moduleType);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        IOwnable ownable;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        IModuleInventory moduleInv = this.getModuleInventory(level);
        if (!(player.isSpectator() || moduleInv == null || moduleInv instanceof IOwnable && !(ownable = (IOwnable)((Object)moduleInv)).isOwnedBy((Entity)player))) {
            if (moduleInv.isModuleEnabled(this.moduleType)) {
                moduleInv.removeModule(this.moduleType, true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(this.moduleType, true), linkable);
                }
            } else {
                moduleInv.insertModule(moduleInv.getModule(this.moduleType), true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    ItemStack stack = moduleInv.getModule(this.moduleType);
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.getItem(), true), linkable);
                }
            }
            if (moduleInv instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)moduleInv;
                player.level().sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private IModuleInventory getModuleInventory(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory be = (IModuleInventory)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof IModuleInventory) {
                IModuleInventory entity2 = (IModuleInventory)entity;
                return entity2;
            }
        }
        return null;
    }
}

