/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ToggleOption
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "toggle_option");
    private BlockPos pos;
    private int optionId;
    private int entityId;

    public ToggleOption() {
    }

    public ToggleOption(BlockPos pos, int optionId) {
        this.pos = pos;
        this.optionId = optionId;
    }

    public ToggleOption(int entityId, int optionId) {
        this.entityId = entityId;
        this.optionId = optionId;
    }

    public ToggleOption(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.optionId = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeBlockPos(this.pos);
        } else {
            buf.writeVarInt(this.entityId);
        }
        buf.writeVarInt(this.optionId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        IOwnable ownable;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.isSpectator() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            customizable.customOptions()[this.optionId].toggle();
            customizable.onOptionChanged(customizable.customOptions()[this.optionId]);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

