/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class UpdateSliderValue
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("securitycraft", "update_slider_value");
    private BlockPos pos;
    private String optionName;
    private double value;
    private int entityId;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, Option<?> option, double v) {
        this.pos = pos;
        this.optionName = option.getName();
        this.value = v;
    }

    public UpdateSliderValue(int entityId, Option<?> option, double v) {
        this.entityId = entityId;
        this.optionName = option.getName();
        this.value = v;
    }

    public UpdateSliderValue(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.optionName = buf.readUtf();
        this.value = buf.readDouble();
    }

    public void write(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeBlockPos(this.pos);
        } else {
            buf.writeVarInt(this.entityId);
        }
        buf.writeUtf(this.optionName);
        buf.writeDouble(this.value);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        IOwnable ownable;
        Player player = (Player)ctx.player().orElseThrow();
        Level level = player.level();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.isSpectator() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            Option<?> option = null;
            for (Option<?> o : customizable.customOptions()) {
                if (!o.getName().equals(this.optionName)) continue;
                option = o;
                break;
            }
            if (option == null) {
                return;
            }
            if (option instanceof Option.EntityDataWrappedOption) {
                Option.EntityDataWrappedOption o = (Option.EntityDataWrappedOption)option;
                Option wrapped = o.getWrapped();
                if (wrapped instanceof Option.DoubleOption) {
                    o.setValue(this.value);
                } else if (wrapped instanceof Option.IntOption) {
                    o.setValue((int)this.value);
                }
            } else if (option instanceof Option.DoubleOption) {
                Option.DoubleOption o = (Option.DoubleOption)option;
                o.setValue(this.value);
            } else if (option instanceof Option.IntOption) {
                Option.IntOption o = (Option.IntOption)option;
                o.setValue((int)this.value);
            }
            customizable.onOptionChanged(option);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

