/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import java.util.Map;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public abstract class AbstractReinforcerRecipe
extends CustomRecipe {
    protected AbstractReinforcerRecipe(CraftingBookCategory category) {
        super(category);
    }

    public abstract Map<Block, Block> getBlockMap();

    public abstract boolean isCorrectReinforcer(ItemStack var1);

    public boolean matches(CraftingContainer inv, Level level) {
        boolean hasCorrectBlock = false;
        boolean hasReinforcer = false;
        Map<Block, Block> blockMap = this.getBlockMap();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockMap.containsKey(blockItem.getBlock())) {
                    if (hasCorrectBlock) {
                        return false;
                    }
                    hasCorrectBlock = true;
                    continue;
                }
                return false;
            }
            if (item instanceof UniversalBlockReinforcerItem) {
                if (hasReinforcer || !this.isCorrectReinforcer(stack)) {
                    return false;
                }
                hasReinforcer = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasReinforcer && hasCorrectBlock;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess lookupProvider) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            Item item = inv.getItem(i).getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            return new ItemStack((ItemLike)this.getBlockMap().get(blockItem.getBlock()));
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList newInv = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < newInv.size(); ++i) {
            ServerPlayer sp;
            ServerPlayer serverPlayer;
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof UniversalBlockReinforcerItem)) continue;
            Player player = CommonHooks.getCraftingPlayer();
            RandomSource random = player != null ? player.getRandom() : ServerLifecycleHooks.getCurrentServer().overworld().getRandom();
            ServerPlayer serverPlayer2 = serverPlayer = player instanceof ServerPlayer ? (sp = (ServerPlayer)player) : null;
            if (stack.hurt(1, random, serverPlayer)) {
                stack.setCount(0);
            }
            newInv.set(i, (Object)stack.copy());
        }
        return newInv;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

