/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.items.MineRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SentryRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.recipe.CombineRecipe;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CopyPositionComponentItemRecipe
extends CombineRecipe {
    private final Holder<Item> item;
    private final Predicate<CompoundTag> isDataEmpty;
    private final RecipeSerializer<? extends CustomRecipe> serializer;

    public CopyPositionComponentItemRecipe(CraftingBookCategory craftingBookCategory, Holder<Item> item, Predicate<CompoundTag> hasData, RecipeSerializer<? extends CustomRecipe> serializer) {
        super(craftingBookCategory);
        this.item = item;
        this.isDataEmpty = Predicate.not(hasData);
        this.serializer = serializer;
    }

    public static CopyPositionComponentItemRecipe cameraMonitor(CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(craftingBookCategory, (Holder<Item>)SCContent.CAMERA_MONITOR, CameraMonitorItem::hasCameraAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_CAMERA_MONITOR_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe mineRemoteAccessTool(CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(craftingBookCategory, (Holder<Item>)SCContent.MINE_REMOTE_ACCESS_TOOL, MineRemoteAccessToolItem::hasMineAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_MINE_REMOTE_ACCESS_TOOL_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe sentryRemoteAccessTool(CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(craftingBookCategory, (Holder<Item>)SCContent.SENTRY_REMOTE_ACCESS_TOOL, SentryRemoteAccessToolItem::hasSentryAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_SENTRY_REMOTE_ACCESS_TOOL_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe sonicSecuritySystem(CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(craftingBookCategory, (Holder<Item>)SCContent.SONIC_SECURITY_SYSTEM_ITEM, SonicSecuritySystemItem::hasLinkedBlock, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_SONIC_SECURITY_SYSTEM_RECIPE_SERIALIZER.get()));
    }

    @Override
    public boolean matchesFirstItem(ItemStack stack) {
        return stack.is(this.item) && !this.isDataEmpty.test(stack.getOrCreateTag());
    }

    @Override
    public boolean matchesSecondItem(ItemStack stack) {
        return stack.is(this.item) && this.isDataEmpty.test(stack.getOrCreateTag());
    }

    @Override
    public ItemStack combine(ItemStack itemWithPositions, ItemStack emptyItem) {
        ItemStack result = new ItemStack(this.item, 2);
        result.getOrCreateTag().merge(itemWithPositions.getOrCreateTag());
        return result;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return this.serializer;
    }
}

