/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class ClaymoreRenderer
implements BlockEntityRenderer<ClaymoreBlockEntity> {
    public ClaymoreRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ClaymoreBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DyeableLeatherItem item;
        if (((Boolean)be.getBlockState().getValue((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        Direction claymoreFacing = (Direction)be.getBlockState().getValue((Property)ClaymoreBlock.FACING);
        Direction rotationDirection = switch (claymoreFacing) {
            case Direction.EAST, Direction.WEST -> claymoreFacing.getOpposite();
            default -> claymoreFacing;
        };
        pose.pushPose();
        pose.translate(0.5, 0.0, 0.5);
        pose.mulPose(Axis.YP.rotationDegrees(rotationDirection.toYRot()));
        pose.translate(-0.5, 0.0, -0.5);
        VertexConsumer builder = buffer.getBuffer(RenderType.lines());
        Matrix4f positionMatrix = pose.last().pose();
        Vec3i normal = claymoreFacing.getNormal();
        float multiplier = 0.0625f;
        float xzStart = 9.0f * multiplier;
        float y = 4.5f * multiplier;
        ItemStack lens = be.getLensContainer().getItem(0);
        int r = 255;
        int g = 255;
        int b = 255;
        Item item2 = lens.getItem();
        if (item2 instanceof DyeableLeatherItem && (item = (DyeableLeatherItem)item2).hasCustomColor(lens)) {
            int color = item.getColor(lens);
            r = color >> 16 & 0xFF;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
        }
        builder.vertex(positionMatrix, xzStart, y, xzStart).color(r, g, b, 255).normal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).endVertex();
        builder.vertex(positionMatrix, 11.0f * multiplier, y, 1.0f).color(r, g, b, 0).normal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).endVertex();
        builder.vertex(positionMatrix, 7.0f * multiplier, y, xzStart).color(r, g, b, 255).normal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).endVertex();
        builder.vertex(positionMatrix, 5.0f * multiplier, y, 1.0f).color(r, g, b, 0).normal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).endVertex();
        pose.popPose();
    }

    public boolean shouldRenderOffScreen(ClaymoreBlockEntity be) {
        return true;
    }
}

