/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity> {
    private final ResourceLocation texture = new ResourceLocation("securitycraft", "textures/entity/display_case.png");
    private final ResourceLocation glowTexture = new ResourceLocation("securitycraft", "textures/entity/glow_display_case.png");
    private final ModelPart main;
    private final ModelPart door;
    private final boolean glowing;

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context ctx, boolean glowing) {
        ModelPart model = ctx.bakeLayer(glowing ? ClientHandler.GLOW_DISPLAY_CASE_LOCATION : ClientHandler.DISPLAY_CASE_LOCATION);
        this.main = model.getChild("main");
        this.door = model.getChild("door");
        this.glowing = glowing;
    }

    public static LayerDefinition createModelLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 23).addBox(-6.0f, -3.0f, -8.0f, 12.0f, 1.0f, 5.0f).texOffs(36, 0).addBox(-6.0f, -13.0f, -8.0f, 1.0f, 10.0f, 5.0f).texOffs(13, 4).addBox(-5.0f, -13.0f, -8.0f, 10.0f, 10.0f, 1.0f).texOffs(0, 0).addBox(5.0f, -13.0f, -8.0f, 1.0f, 10.0f, 5.0f).texOffs(0, 16).addBox(-6.0f, -14.0f, -8.0f, 12.0f, 1.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("door", CubeListBuilder.create().texOffs(5, 31).addBox(1.0f, -5.0f, 0.0f, 10.0f, 10.0f, 1.0f).texOffs(0, 31).addBox(11.0f, -5.0f, 0.0f, 1.0f, 10.0f, 1.0f).texOffs(28, 31).addBox(0.0f, -5.0f, 0.0f, 1.0f, 10.0f, 1.0f).texOffs(0, 43).addBox(0.0f, -6.0f, 0.0f, 12.0f, 1.0f, 1.0f).texOffs(0, 46).addBox(0.0f, 5.0f, 0.0f, 12.0f, 1.0f, 1.0f).texOffs(27, 43).addBox(11.0f, -1.5f, 1.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-6.0f, (float)16.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)48, (int)48);
    }

    public void render(DisplayCaseBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)DisplayCaseBlock.FACING);
        float rotation = facing.toYRot();
        ItemStack displayedStack = be.getDisplayedStack();
        int light = this.glowing ? 15728850 : packedLight;
        this.door.yRot = -(be.getOpenness(partialTick) * 1.5707964f);
        pose.pushPose();
        pose.translate(0.5, 0.5, 0.5);
        if (!displayedStack.isEmpty()) {
            double insertionAmount = 0.40625;
            pose.pushPose();
            switch ((AttachFace)state.getValue(DisplayCaseBlock.ATTACH_FACE)) {
                case CEILING: {
                    pose.translate(0.0, insertionAmount, 0.0);
                    pose.mulPose(Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case FLOOR: {
                    pose.translate(0.0, -insertionAmount, 0.0);
                    pose.mulPose(Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case WALL: {
                    pose.mulPose(Axis.YP.rotationDegrees(180.0f));
                    pose.mulPose(Axis.YP.rotationDegrees(-rotation));
                    pose.translate(0.0, 0.0, insertionAmount);
                }
            }
            pose.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(displayedStack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, pose, buffer, be.getLevel(), 0);
            pose.popPose();
        }
        pose.mulPose(Axis.YP.rotationDegrees(-rotation));
        switch ((AttachFace)state.getValue(DisplayCaseBlock.ATTACH_FACE)) {
            case CEILING: {
                pose.translate(0.0, 0.0, 1.0);
                pose.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case FLOOR: {
                pose.translate(0.0, 0.0, -1.0);
                pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WALL: {
                pose.translate(0.0, 1.0, 0.0);
                pose.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)(this.glowing ? this.glowTexture : this.texture)));
        pose.scale(-1.0f, 1.0f, -1.0f);
        this.main.render(pose, consumer, light, packedOverlay);
        this.door.render(pose, consumer, light, packedOverlay);
        pose.popPose();
    }
}

