/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class IMSBombRenderer
extends EntityRenderer<IMSBomb> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/entity/ims_bomb.png");
    private final IMSBombModel model;

    public IMSBombRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new IMSBombModel(ctx.bakeLayer(ClientHandler.IMS_BOMB_LOCATION));
    }

    public void render(IMSBomb imsBomb, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        pose.translate(-0.1, 0.0, 0.1);
        pose.scale(1.4f, 1.4f, 1.4f);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(imsBomb));
        this.model.renderToBuffer(pose, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTextureLocation(imsBomb))), packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(IMSBomb imsBomb) {
        return TEXTURE;
    }
}

