/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RetinalScannerRenderer
implements BlockEntityRenderer<RetinalScannerBlockEntity> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public RetinalScannerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RetinalScannerBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay)) {
            return;
        }
        Direction direction = (Direction)be.getBlockState().getValue((Property)RetinalScannerBlock.FACING);
        if (direction != null) {
            if (be.isModuleEnabled(ModuleType.DISGUISE) && ModuleItem.getBlockAddon(be.getModule(ModuleType.DISGUISE)) != null) {
                return;
            }
            pose.pushPose();
            switch (direction) {
                case NORTH: {
                    pose.translate(0.25f, 0.0625f, 0.0f);
                    break;
                }
                case SOUTH: {
                    pose.translate(0.75f, 0.0625f, 1.0f);
                    pose.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    pose.translate(0.0f, 0.0625f, 0.75f);
                    pose.mulPose(Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    pose.translate(1.0f, 0.0625f, 0.25f);
                    pose.mulPose(Axis.YP.rotationDegrees(270.0f));
                    break;
                }
            }
            pose.scale(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)RetinalScannerRenderer.getSkinTexture(be.getPlayerProfile())));
            Matrix4f positionMatrix = pose.last().pose();
            Matrix3f normalMatrix = pose.last().normal();
            Vec3i normalVector = direction.getNormal();
            BlockPos offsetPos = be.getBlockPos().relative(direction);
            combinedLight = LightTexture.pack((int)be.getLevel().getBrightness(LightLayer.BLOCK, offsetPos), (int)be.getLevel().getBrightness(LightLayer.SKY, offsetPos));
            vertexBuilder.vertex(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).color(255, 255, 255, 255).uv(0.125f, 0.25f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).color(255, 255, 255, 255).uv(0.125f, 0.125f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).color(255, 255, 255, 255).uv(0.25f, 0.125f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).color(255, 255, 255, 255).uv(0.25f, 0.25f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).color(255, 255, 255, 255).uv(0.625f, 0.25f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).color(255, 255, 255, 255).uv(0.625f, 0.125f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).color(255, 255, 255, 255).uv(0.75f, 0.125f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            vertexBuilder.vertex(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).color(255, 255, 255, 255).uv(0.75f, 0.25f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normalMatrix, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ()).endVertex();
            pose.popPose();
        }
    }

    private static ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && profile != null) {
            return Minecraft.getInstance().getSkinManager().getInsecureSkin(profile).texture();
        }
        return DefaultPlayerSkin.getDefaultTexture();
    }
}

