/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class SecurityCameraRenderer
implements BlockEntityRenderer<SecurityCameraBlockEntity> {
    private static final Quaternionf POSITIVE_Y_180 = Axis.YP.rotationDegrees(180.0f);
    private static final Quaternionf POSITIVE_Y_90 = Axis.YP.rotationDegrees(90.0f);
    private static final Quaternionf NEGATIVE_Y_90 = Axis.YN.rotationDegrees(90.0f);
    private static final Quaternionf POSITIVE_X_180 = Axis.XP.rotationDegrees(180.0f);
    public static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/entity/security_camera/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft", "textures/entity/security_camera/security_camera_viewing.png");
    private final SecurityCameraModel model;

    public SecurityCameraRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecurityCameraModel(ctx.bakeLayer(ClientHandler.SECURITY_CAMERA_LOCATION));
    }

    public void render(SecurityCameraBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (FrameFeedHandler.amIBeingCaptured(be) || PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.getInstance().player) && Minecraft.getInstance().cameraEntity.blockPosition().equals((Object)be.getBlockPos())) {
            return;
        }
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, packedLight, packedOverlay);
        if (be.isDown()) {
            return;
        }
        if (!be.isModuleEnabled(ModuleType.DISGUISE)) {
            DyeableLeatherItem item;
            BlockState state;
            pose.translate(0.5, 1.5, 0.5);
            if (be.hasLevel() && (state = be.getLevel().getBlockState(be.getBlockPos())).getBlock() == SCContent.SECURITY_CAMERA.get()) {
                Direction side = (Direction)state.getValue((Property)SecurityCameraBlock.FACING);
                if (side == Direction.NORTH) {
                    pose.mulPose(POSITIVE_Y_180);
                } else if (side == Direction.EAST) {
                    pose.mulPose(POSITIVE_Y_90);
                } else if (side == Direction.WEST) {
                    pose.mulPose(NEGATIVE_Y_90);
                }
            }
            pose.mulPose(POSITIVE_X_180);
            this.model.rotateCameraY((float)Mth.lerp((double)partialTicks, (double)be.getOriginalCameraRotation(), (double)be.getCameraRotation()));
            if (be.isShutDown()) {
                this.model.rotateCameraX(0.9f);
            } else {
                this.model.rotateCameraX(0.2617994f);
            }
            ItemStack lens = be.getLensContainer().getItem(0);
            float r = 0.4392157f;
            float g = 1.0f;
            float b = 1.0f;
            Item item2 = lens.getItem();
            if (item2 instanceof DyeableLeatherItem && (item = (DyeableLeatherItem)item2).hasCustomColor(lens)) {
                int color = item.getColor(lens);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            } else {
                this.model.cameraRotationPoint2.visible = false;
            }
            this.model.renderToBuffer(pose, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)((Boolean)be.getBlockState().getValue((Property)SecurityCameraBlock.BEING_VIEWED) != false ? BEING_VIEWED_TEXTURE : TEXTURE))), packedLight, OverlayTexture.NO_OVERLAY, r, g, b, 1.0f);
            this.model.cameraRotationPoint2.visible = true;
        }
    }
}

