/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.geforcemods.securitycraft.models.SecuritySeaBoatModel;
import net.geforcemods.securitycraft.models.SecuritySeaRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class SecuritySeaBoatRenderer
extends BoatRenderer {
    public SecuritySeaBoatRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, true);
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("securitycraft", "textures/entity/security_sea_boat/" + type.getName() + ".png"), this.createBoatModel(ctx, (Boat.Type)type, true))));
    }

    public ListModel<Boat> createBoatModel(EntityRendererProvider.Context ctx, Boat.Type type, boolean chestBoat) {
        ModelPart modelPart = ctx.bakeLayer(ModelLayers.createChestBoatModelName((Boat.Type)type));
        if (type == Boat.Type.BAMBOO) {
            return new SecuritySeaRaftModel(modelPart);
        }
        return new SecuritySeaBoatModel(modelPart);
    }
}

