/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.models.SentryModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SentryRenderer
extends EntityRenderer<Sentry> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/entity/sentry.png");
    private final SentryModel model;

    public SentryRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new SentryModel(ctx.bakeLayer(ClientHandler.SENTRY_LOCATION));
    }

    public void render(Sentry entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        VertexConsumer builder = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTextureLocation(entity)));
        pose.pushPose();
        pose.translate(0.0, 1.5, 0.0);
        pose.scale(-1.0f, -1.0f, 1.0f);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
        this.model.renderBase(pose, builder, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.getOriginalHeadRotation(), (float)entity.getHeadRotation())));
        pose.translate(0.0f, entity.getHeadYTranslation(partialTicks), 0.0f);
        this.model.renderToBuffer(pose, builder, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.popPose();
    }

    public ResourceLocation getTextureLocation(Sentry entity) {
        return TEXTURE;
    }
}

