/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.geforcemods.securitycraft.network.server.SyncBlockReinforcer;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlockReinforcerScreen
extends AbstractContainerScreen<BlockReinforcerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/universal_block_reinforcer.png");
    private static final ResourceLocation TEXTURE_LVL1 = new ResourceLocation("securitycraft", "textures/gui/container/universal_block_reinforcer_lvl1.png");
    private final Component output = Utils.localize("gui.securitycraft:blockReinforcer.output", new Object[0]);
    private CallbackCheckbox unreinforceCheckbox;

    public BlockReinforcerScreen(BlockReinforcerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageHeight = 186;
    }

    protected void init() {
        super.init();
        this.unreinforceCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(this.leftPos + 24, this.topPos + 69, 20, 20, (Component)Component.empty(), !((BlockReinforcerMenu)this.menu).isReinforcing, this::updateTooltip, 0));
        this.updateTooltip(this.unreinforceCheckbox.selected());
        if (((BlockReinforcerMenu)this.menu).isLvl1) {
            this.unreinforceCheckbox.visible = false;
        }
    }

    private void updateTooltip(boolean isSelected) {
        if (isSelected) {
            this.unreinforceCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.securitycraft:blockReinforcer.unreinforceCheckbox.checked")));
        } else {
            this.unreinforceCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.securitycraft:blockReinforcer.unreinforceCheckbox.not_checked")));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        NonNullList inv = ((BlockReinforcerMenu)this.menu).getItems();
        guiGraphics.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2, 5, 0x404040, false);
        guiGraphics.drawString(this.font, Utils.INVENTORY_TEXT, 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (!((ItemStack)inv.get(36)).isEmpty()) {
            guiGraphics.drawString(this.font, this.output, 50, 25, 0x404040, false);
            guiGraphics.renderItem(((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), 116, 20);
            guiGraphics.renderItemDecorations(this.minecraft.font, ((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), 116, 20, null);
            if (mouseX >= this.leftPos + 114 && mouseX < this.leftPos + 134 && mouseY >= this.topPos + 17 && mouseY < this.topPos + 39) {
                guiGraphics.renderTooltip(this.font, ((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), mouseX - this.leftPos, mouseY - this.topPos);
            }
        }
        if (!((BlockReinforcerMenu)this.menu).isLvl1 && !((ItemStack)inv.get(37)).isEmpty()) {
            guiGraphics.drawString(this.font, this.output, 50, 50, 0x404040, false);
            guiGraphics.renderItem(((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), 116, 46);
            guiGraphics.renderItemDecorations(this.minecraft.font, ((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), 116, 46, null);
            if (mouseX >= this.leftPos + 114 && mouseX < this.leftPos + 134 && mouseY >= this.topPos + 43 && mouseY < this.topPos + 64) {
                guiGraphics.renderTooltip(this.font, ((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), mouseX - this.leftPos, mouseY - this.topPos);
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(((BlockReinforcerMenu)this.menu).isLvl1 ? TEXTURE_LVL1 : TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SyncBlockReinforcer(!this.unreinforceCheckbox.selected())});
    }
}

