/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class CameraSelectScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final List<Pair<GlobalPos, String>> cameras;
    protected final boolean readOnly;
    private final Button[] cameraButtons = new Button[10];
    private final CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int xSize = 176;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private int page;

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly) {
        this(cameras, readOnly, 1);
    }

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly, int page) {
        super((Component)Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]));
        this.cameras = cameras;
        this.readOnly = readOnly;
        this.page = page;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        Button prevPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 25, this.height / 2 + 57, 20, 20, (Component)Component.literal((String)"<"), b -> {
            --this.page;
            this.rebuildWidgets();
        }, Button.DEFAULT_NARRATION));
        Button nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 5, this.height / 2 + 57, 20, 20, (Component)Component.literal((String)">"), b -> {
            ++this.page;
            this.rebuildWidgets();
        }, Button.DEFAULT_NARRATION));
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.leftPos + 18 + i % 5 * 30;
            int y = this.topPos + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            Pair<GlobalPos, String> pair = this.cameras.get(camID - 1);
            GlobalPos view = (GlobalPos)pair.getLeft();
            Button cameraButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.empty(), button -> this.cameraButtonClicked(button, camID), Button.DEFAULT_NARRATION));
            if (!this.readOnly) {
                ((SmallButton)this.addRenderableWidget((GuiEventListener)SmallButton.createWithX((int)(x + 19), (int)aboveCameraButton, (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$3(int net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((CameraSelectScreen)this, (int)camID)))).active = view != null;
            }
            this.cameraButtons[i] = cameraButton;
            cameraButton.setMessage((Component)cameraButton.getMessage().plainCopy().append((Component)Component.literal((String)("" + camID))));
            this.redstoneModuleStates[i] = null;
            if (view != null) {
                SecurityCameraBlockEntity camera;
                BlockPos pos = view.pos();
                BlockEntity blockEntity = level.getBlockEntity(pos);
                SecurityCameraBlockEntity cameraBe = blockEntity instanceof SecurityCameraBlockEntity ? (camera = (SecurityCameraBlockEntity)blockEntity) : null;
                String cameraName = (String)pair.getRight();
                if (cameraBe != null) {
                    BlockState state = level.getBlockState(pos);
                    if (cameraBe.isDisabled() || cameraBe.isShutDown()) {
                        cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
                        cameraButton.active = false;
                    } else if (cameraName != null && cameraBe.hasCustomName()) {
                        cameraName = cameraBe.getCustomName().getString();
                    }
                    this.redstoneModuleStates[i] = state.getSignal((BlockGetter)level, pos, (Direction)state.getValue((Property)SecurityCameraBlock.FACING)) == 0 ? (!cameraBe.isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (cameraButton.active && cameraName != null) {
                    cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:monitor.cameraName", cameraName)));
                }
                if (!player.isCreative()) continue;
                Button tpButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.create(x, aboveCameraButton, (Component)Component.empty(), b -> {
                    player.connection.sendUnsignedCommand(String.format("execute in %s run tp %s %s %s", view.dimension().location(), pos.getX(), pos.getY(), pos.getZ()));
                    this.minecraft.setScreen(null);
                }));
                tpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"chat.coordinates.tooltip")));
                continue;
            }
            cameraButton.active = false;
        }
        prevPageButton.active = this.page != 1;
        nextPageButton.active = this.page != 3;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 10; ++i) {
            Button button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render(guiGraphics, button.getX() + 4, button.getY() + 25);
        }
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
    }

    private void cameraButtonClicked(Button button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            SecurityCameraBlockEntity cameraEntity;
            GlobalPos cameraPos = (GlobalPos)camera.getLeft();
            BlockEntity blockEntity = this.minecraft.level.getBlockEntity(cameraPos.pos());
            if (blockEntity instanceof SecurityCameraBlockEntity && ((cameraEntity = (SecurityCameraBlockEntity)blockEntity).isDisabled() || cameraEntity.isShutDown())) {
                button.active = false;
                return;
            }
            this.viewCamera(cameraPos);
        }
    }

    protected void viewCamera(GlobalPos cameraPos) {
        Minecraft.getInstance().player.closeContainer();
    }

    private void unbindButtonClicked(Button button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            int i = (camID - 1) % 10;
            Button cameraButton = this.cameraButtons[i];
            this.unbindCamera(camID);
            button.active = false;
            cameraButton.active = false;
            cameraButton.setTooltip(null);
            this.redstoneModuleStates[i] = null;
        }
    }

    protected void unbindCamera(int camID) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$init$3(int camID, Button button) {
        this.unbindButtonClicked(button, camID);
    }
}

