/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class CheckPasscodeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/check_passcode.png");
    private static final Component COOLDOWN_TEXT_1 = Component.translatable((String)"gui.securitycraft:passcode.cooldown1");
    private int cooldownText1XPos;
    private IPasscodeProtected passcodeProtected;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private int imageWidth = 176;
    private int imageHeight = 186;
    private int leftPos;
    private int topPos;
    private CensoringEditBox keycodeTextbox;
    private boolean wasOnCooldownLastRenderTick = false;

    public CheckPasscodeScreen(IPasscodeProtected passcodeProtected, Component title) {
        super(title);
        this.passcodeProtected = passcodeProtected;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.cooldownText1XPos = this.width / 2 - this.font.width((FormattedText)COOLDOWN_TEXT_1) / 2;
        this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(this.width / 2 - 37, this.height / 2 - 55, 12, 12, (Component)Component.translatable((String)"gui.securitycraft:passcode.showPasscode"), false, newState -> this.keycodeTextbox.setCensoring(newState == false), 0x404040));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 33, this.height / 2 - 35, 20, 20, (Component)Component.literal((String)"1"), b -> this.addNumberToString(1), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 8, this.height / 2 - 35, 20, 20, (Component)Component.literal((String)"2"), b -> this.addNumberToString(2), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 17, this.height / 2 - 35, 20, 20, (Component)Component.literal((String)"3"), b -> this.addNumberToString(3), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 33, this.height / 2 - 10, 20, 20, (Component)Component.literal((String)"4"), b -> this.addNumberToString(4), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 8, this.height / 2 - 10, 20, 20, (Component)Component.literal((String)"5"), b -> this.addNumberToString(5), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 17, this.height / 2 - 10, 20, 20, (Component)Component.literal((String)"6"), b -> this.addNumberToString(6), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 33, this.height / 2 + 15, 20, 20, (Component)Component.literal((String)"7"), b -> this.addNumberToString(7), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 8, this.height / 2 + 15, 20, 20, (Component)Component.literal((String)"8"), b -> this.addNumberToString(8), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 17, this.height / 2 + 15, 20, 20, (Component)Component.literal((String)"9"), b -> this.addNumberToString(9), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 33, this.height / 2 + 40, 20, 20, (Component)Component.literal((String)"\u2190"), b -> this.removeLastCharacter(), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 8, this.height / 2 + 40, 20, 20, (Component)Component.literal((String)"0"), b -> this.addNumberToString(0), Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 17, this.height / 2 + 40, 20, 20, (Component)Component.literal((String)"\u2714"), b -> this.checkCode(this.keycodeTextbox.getValue()), Button.DEFAULT_NARRATION));
        this.keycodeTextbox = (CensoringEditBox)this.addRenderableWidget((GuiEventListener)new CensoringEditBox(this.font, this.width / 2 - 37, this.height / 2 - 72, 77, 12, (Component)Component.empty()){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.active && super.mouseClicked(mouseX, mouseY, button);
            }

            public boolean canConsumeInput() {
                return this.active && this.isVisible();
            }
        });
        this.keycodeTextbox.setMaxLength(Integer.MAX_VALUE);
        this.keycodeTextbox.setFilter(s -> s.matches("\\d*\\**"));
        if (this.passcodeProtected.isOnCooldown()) {
            this.toggleChildrenActive(false);
        } else {
            this.setInitialFocus((GuiEventListener)this.keycodeTextbox);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
        if (this.passcodeProtected.isOnCooldown()) {
            long cooldownEnd = this.passcodeProtected.getCooldownEnd();
            long secondsLeft = Math.max(cooldownEnd - System.currentTimeMillis(), 0L) / 1000L + 1L;
            MutableComponent text = Component.translatable((String)"gui.securitycraft:passcode.cooldown2", (Object[])new Object[]{secondsLeft});
            guiGraphics.drawString(this.font, COOLDOWN_TEXT_1, this.cooldownText1XPos, this.height / 2 + 65, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)text, this.width / 2 - this.font.width((FormattedText)text) / 2, this.height / 2 + 75, 0x404040, false);
            if (!this.wasOnCooldownLastRenderTick) {
                this.wasOnCooldownLastRenderTick = true;
            }
        } else if (this.wasOnCooldownLastRenderTick) {
            this.wasOnCooldownLastRenderTick = false;
            this.toggleChildrenActive(true);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && !this.keycodeTextbox.getValue().isEmpty()) {
            this.minecraft.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.15f, 1.0f);
        }
        if (!super.keyPressed(keyCode, scanCode, modifiers) && !this.keycodeTextbox.keyPressed(keyCode, scanCode, modifiers)) {
            if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
                this.onClose();
            }
            if (!(this.passcodeProtected.isOnCooldown() || keyCode != 257 && keyCode != 335)) {
                this.minecraft.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.15f, 1.0f);
                this.checkCode(this.keycodeTextbox.getValue());
            }
        }
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.passcodeProtected.isOnCooldown() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.charTyped(typedChar, keyCode);
            this.minecraft.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.15f, 1.0f);
        }
        return true;
    }

    private boolean isValidChar(char c) {
        for (char allowedChar : this.allowedChars) {
            if (c != allowedChar) continue;
            return true;
        }
        return false;
    }

    private void addNumberToString(int number) {
        this.keycodeTextbox.insertText("" + number);
    }

    private void removeLastCharacter() {
        if (!this.keycodeTextbox.getValue().isEmpty()) {
            this.keycodeTextbox.deleteChars(-1);
        }
    }

    private void toggleChildrenActive(boolean setActive) {
        this.children().forEach(listener -> {
            if (listener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)listener;
                widget.active = setActive;
            }
        });
        this.keycodeTextbox.setFocused(setActive);
    }

    public void checkCode(String code) {
        IModuleInventory moduleInv;
        IPasscodeProtected iPasscodeProtected = this.passcodeProtected;
        if (iPasscodeProtected instanceof IModuleInventory && (moduleInv = (IModuleInventory)((Object)iPasscodeProtected)).isModuleEnabled(ModuleType.SMART)) {
            this.toggleChildrenActive(false);
        }
        this.keycodeTextbox.setValue("");
        IPasscodeProtected iPasscodeProtected2 = this.passcodeProtected;
        if (iPasscodeProtected2 instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iPasscodeProtected2;
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new CheckPasscode(be.getBlockPos(), code)});
        } else {
            iPasscodeProtected2 = this.passcodeProtected;
            if (iPasscodeProtected2 instanceof Entity) {
                Entity entity = (Entity)iPasscodeProtected2;
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new CheckPasscode(entity.getId(), code)});
            }
        }
    }

    public static class CensoringEditBox
    extends EditBox {
        private String renderedText = "";
        private boolean shouldCensor = true;

        public CensoringEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
            this.setResponder(this::updateRenderedText);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            String originalValue = this.value;
            this.value = this.renderedText;
            boolean success = super.mouseClicked(mouseX, mouseY, button);
            this.value = originalValue;
            return success;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            String originalValue = this.value;
            this.value = this.renderedText;
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            this.value = originalValue;
        }

        public void scrollTo(int position) {
            String originalValue = this.value;
            this.updateRenderedText(originalValue);
            this.value = this.renderedText;
            super.scrollTo(position);
            this.value = originalValue;
        }

        public void setCensoring(boolean shouldCensor) {
            this.shouldCensor = shouldCensor;
            this.updateRenderedText(this.value);
        }

        private void updateRenderedText(String original) {
            if (this.shouldCensor) {
                Object x = "";
                for (int i = 1; i <= original.length(); ++i) {
                    x = (String)x + "*";
                }
                this.renderedText = x;
            } else {
                this.renderedText = original;
            }
        }
    }
}

