/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class CustomizeBlockScreen
extends AbstractContainerScreen<CustomizeBlockMenu>
implements IHasExtraAreas,
ContainerListener {
    private static final ResourceLocation CONFIRM_SPRITE = new ResourceLocation("container/beacon/confirm");
    private static final ResourceLocation CANCEL_SPRITE = new ResourceLocation("container/beacon/cancel");
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private final int maxNumberOfModules;
    private final ResourceLocation texture;
    private final PictureButton[] descriptionButtons;
    private IModuleInventory moduleInv;
    private AbstractWidget[] optionButtons;
    private EnumMap<ModuleType, Boolean> indicators = new EnumMap(ModuleType.class);

    public CustomizeBlockScreen(CustomizeBlockMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.moduleInv = menu.moduleInv;
        this.maxNumberOfModules = this.moduleInv.getMaxNumberOfModules();
        this.texture = new ResourceLocation("securitycraft", "textures/gui/container/customize" + this.maxNumberOfModules + ".png");
        this.descriptionButtons = new PictureButton[this.maxNumberOfModules];
        menu.addSlotListener(this);
        for (ModuleType type : ModuleType.values()) {
            if (this.moduleInv.hasModule(type)) {
                this.indicators.put(type, this.moduleInv.isModuleEnabled(type));
                continue;
            }
            this.indicators.put(type, true);
        }
    }

    public void init() {
        ICustomizable customizable;
        Option<?>[] options;
        super.init();
        int numberOfColumns = 2;
        for (int i = 0; i < this.maxNumberOfModules; ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = (PictureButton)this.addRenderableWidget((GuiEventListener)new ModuleButton(this.leftPos + 127 + column * 22, this.topPos + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.moduleInv.acceptedModules()[i].getItem(), this::moduleButtonClicked));
            this.descriptionButtons[i].setTooltip(Tooltip.create((Component)this.getModuleTooltipText(i)));
            this.descriptionButtons[i].active = this.moduleInv.hasModule(this.moduleInv.acceptedModules()[i]);
        }
        IModuleInventory column = this.moduleInv;
        if (column instanceof ICustomizable && (options = (customizable = (ICustomizable)((Object)column)).customOptions()).length > 0) {
            this.optionButtons = new AbstractWidget[options.length];
            for (int i = 0; i < options.length; ++i) {
                Option<?> option;
                Option<?> option2 = options[i];
                if (option2 instanceof Option.EntityDataWrappedOption) {
                    Option.EntityDataWrappedOption wrapped = (Option.EntityDataWrappedOption)option2;
                    v0 = wrapped.getWrapped();
                } else {
                    v0 = option = options[i];
                }
                if (option.isSlider()) {
                    if (option instanceof Option.DoubleOption) {
                        Option.DoubleOption doubleOption = (Option.DoubleOption)option;
                        sliderIndex = i;
                        this.optionButtons[i] = new CallbackSlider(this.leftPos + 178, this.topPos + 10 + i * 25, 120, 20, (Component)Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), ""), (Component)Component.empty(), (Double)doubleOption.getMin(), (Double)doubleOption.getMax(), (Double)doubleOption.get(), (Double)doubleOption.getIncrement(), 0, true, slider -> {
                            doubleOption.setValue(slider.getValue());
                            this.optionButtons[sliderIndex].setTooltip(Tooltip.create((Component)this.getOptionDescription(sliderIndex)));
                            if (((CustomizeBlockMenu)this.menu).entityId == -1) {
                                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateSliderValue(this.moduleInv.myPos(), option, (double)((Double)doubleOption.get()))});
                            } else {
                                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateSliderValue(((CustomizeBlockMenu)this.menu).entityId, option, (double)((Double)doubleOption.get()))});
                            }
                        }){

                            protected void updateMessage() {
                                this.setMessage(CustomizeBlockScreen.this.getOptionButtonTitle(option));
                            }
                        };
                    } else if (option instanceof Option.IntOption) {
                        Option.IntOption intOption = (Option.IntOption)option;
                        sliderIndex = i;
                        this.optionButtons[i] = new CallbackSlider(this.leftPos + 178, this.topPos + 10 + i * 25, 120, 20, (Component)Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), ""), (Component)Component.empty(), (double)((Integer)intOption.getMin()).intValue(), (double)((Integer)intOption.getMax()).intValue(), (double)((Integer)intOption.get()).intValue(), true, slider -> {
                            intOption.setValue(slider.getValueInt());
                            this.optionButtons[sliderIndex].setTooltip(Tooltip.create((Component)this.getOptionDescription(sliderIndex)));
                            if (((CustomizeBlockMenu)this.menu).entityId == -1) {
                                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateSliderValue(this.moduleInv.myPos(), option, (double)((Integer)intOption.get()).intValue())});
                            } else {
                                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateSliderValue(((CustomizeBlockMenu)this.menu).entityId, option, (double)((Integer)intOption.get()).intValue())});
                            }
                        }){

                            protected void updateMessage() {
                                this.setMessage(CustomizeBlockScreen.this.getOptionButtonTitle(option));
                            }
                        };
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new Button(this.leftPos + 178, this.topPos + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::optionButtonClicked, Button.DEFAULT_NARRATION);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.addRenderableWidget((GuiEventListener)this.optionButtons[i]);
                this.optionButtons[i].setTooltip(Tooltip.create((Component)this.getOptionDescription(i)));
            }
            for (AbstractWidget button : this.optionButtons) {
                this.extraAreas.add(new Rect2i(button.getX(), button.getY(), button.getWidth(), button.getHeight()));
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 36; i < ((CustomizeBlockMenu)this.menu).getMaxSlots(); ++i) {
            ModuleType type;
            Slot slot = (Slot)((CustomizeBlockMenu)this.menu).slots.get(i);
            if (slot.getItem().isEmpty() || !this.indicators.containsKey((Object)(type = ((ModuleItem)slot.getItem().getItem()).getModuleType()))) continue;
            guiGraphics.blitSprite(this.indicators.get((Object)type) != false ? CONFIRM_SPRITE : CANCEL_SPRITE, this.leftPos + slot.x, this.topPos + slot.y + 16, 18, 18);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, 0x404040, false);
        guiGraphics.drawString(this.font, Utils.INVENTORY_TEXT, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(this.texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void slotChanged(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
        if (slotIndex < 36) {
            return;
        }
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            if (this.descriptionButtons[i] == null) continue;
            ModuleType type = this.moduleInv.acceptedModules()[i];
            this.descriptionButtons[i].active = this.moduleInv.hasModule(type);
            if (!this.descriptionButtons[i].active) {
                this.indicators.remove((Object)type);
                continue;
            }
            this.indicators.computeIfAbsent(type, t -> true);
        }
    }

    private void moduleButtonClicked(Button button) {
        ModuleType moduleType = ((ModuleButton)button).getModule().getModuleType();
        if (this.moduleInv.isModuleEnabled(moduleType)) {
            this.indicators.put(moduleType, false);
            this.moduleInv.removeModule(moduleType, true);
        } else {
            this.indicators.put(moduleType, true);
            this.moduleInv.insertModule(this.moduleInv.getModule(moduleType), true);
        }
        if (((CustomizeBlockMenu)this.menu).entityId == -1) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleModule(this.moduleInv.myPos(), moduleType)});
        } else {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleModule(((CustomizeBlockMenu)this.menu).entityId, moduleType)});
        }
    }

    private void optionButtonClicked(Button button) {
        for (int i = 0; i < this.optionButtons.length; ++i) {
            if (button != this.optionButtons[i]) continue;
            Option<?> tempOption = ((ICustomizable)((Object)this.moduleInv)).customOptions()[i];
            tempOption.toggle();
            button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
            button.setMessage(this.getOptionButtonTitle(tempOption));
            this.optionButtons[i].setTooltip(Tooltip.create((Component)this.getOptionDescription(i)));
            if (((CustomizeBlockMenu)this.menu).entityId == -1) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleOption(this.moduleInv.myPos(), i)});
            } else {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleOption(((CustomizeBlockMenu)this.menu).entityId, i)});
            }
            return;
        }
    }

    private Component getModuleTooltipText(int moduleId) {
        return Utils.localize(this.descriptionButtons[moduleId].getItemStack().getDescriptionId(), new Object[0]).append((Component)Component.literal((String)":")).withStyle(ChatFormatting.RESET).append((Component)Component.literal((String)"\n\n")).append((Component)Utils.localize(this.moduleInv.getModuleDescriptionId(Utils.getLanguageKeyDenotation(this.moduleInv), ((ModuleItem)this.descriptionButtons[moduleId].getItemStack().getItem()).getModuleType()), new Object[0]));
    }

    private Component getOptionDescription(int optionId) {
        Option<?> option = ((ICustomizable)((Object)this.moduleInv)).customOptions()[optionId];
        return Utils.localize("gui.securitycraft:customize.tooltip", Component.translatable((String)option.getDescriptionKey(Utils.getLanguageKeyDenotation(this.moduleInv))), Component.translatable((String)"gui.securitycraft:customize.currentSetting", (Object[])new Object[]{option.getValueText()}));
    }

    private Component getOptionButtonTitle(Option<?> option) {
        return Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), option.getValueText());
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void dataChanged(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    private class ModuleButton
    extends PictureButton {
        private final ModuleItem module;

        public ModuleButton(int xPos, int yPos, int width, int height, ModuleItem itemToRender, Button.OnPress onPress) {
            super(xPos, yPos, width, height, new ItemStack((ItemLike)itemToRender), onPress);
            this.module = itemToRender;
        }

        public ModuleItem getModule() {
            return this.module;
        }
    }
}

