/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.screen.components.StateSelector;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class DisguiseModuleScreen
extends AbstractContainerScreen<DisguiseModuleMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/customize1.png");
    private final Component disguiseModuleName = Utils.localize(((ModuleItem)((Object)SCContent.DISGUISE_MODULE.get())).getDescriptionId(), new Object[0]);
    private StateSelector stateSelector;

    public DisguiseModuleScreen(DisguiseModuleMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void init() {
        super.init();
        this.leftPos += 90;
        this.stateSelector = (StateSelector)this.addRenderableWidget(new StateSelector((StateSelectorAccessMenu)this.menu, this.title, this.leftPos - 190, this.topPos + 7, 0, 200, 15, 236, 50));
        this.stateSelector.init(this.minecraft, this.width, this.height);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.disguiseModuleName, this.imageWidth / 2 - this.font.width((FormattedText)this.disguiseModuleName) / 2, 6, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stateSelector != null && this.stateSelector.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void onClose() {
        super.onClose();
        ItemStack module = ((DisguiseModuleMenu)this.menu).getInventory().getModule();
        CompoundTag moduleTag = module.getOrCreateTag();
        BlockState state = Blocks.AIR.defaultBlockState();
        StandingOrWallType standingOrWall = StandingOrWallType.NONE;
        if (!((DisguiseModuleMenu)this.menu).getSlot(0).getItem().isEmpty() && this.stateSelector.getState() != null) {
            state = this.stateSelector.getState();
            standingOrWall = this.stateSelector.getStandingOrWallType();
        }
        moduleTag.put("SavedState", (Tag)NbtUtils.writeBlockState((BlockState)state));
        moduleTag.putInt("StandingOrWall", standingOrWall.ordinal());
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SetStateOnDisguiseModule(state, standingOrWall)});
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getGuiExtraAreas();
        }
        return List.of();
    }
}

