/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.network.PacketDistributor;

public class EditModuleScreen
extends Screen {
    private static CompoundTag savedModule;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation CONFIRM_SPRITE;
    private static final ResourceLocation CANCEL_SPRITE;
    private final Component editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]);
    private final ItemStack module;
    private final List<PlayerTeam> availableTeams;
    private final Map<PlayerTeam, Boolean> teamsListedStatus = new HashMap<PlayerTeam, Boolean>();
    private EditBox inputField;
    private Button addPlayerButton;
    private Button removePlayerButton;
    private Button copyButton;
    private Button pasteButton;
    private Button clearButton;
    private CallbackCheckbox affectEveryPlayerCheckbox;
    private int xSize = 247;
    private int ySize = 211;
    private int leftPos;
    private int topPos;
    private PlayerList playerList;
    private TeamList teamList;

    public EditModuleScreen(ItemStack item) {
        super((Component)Component.translatable((String)item.getDescriptionId()));
        this.availableTeams = new ArrayList<PlayerTeam>(Minecraft.getInstance().player.getScoreboard().getPlayerTeams());
        this.module = item;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        int guiLeft = (this.width - this.xSize) / 2;
        int guiTop = (this.height - this.ySize) / 2;
        int controlsStartX = (int)((float)guiLeft + (float)this.xSize * 0.75f) - 57;
        int controlsWidth = 107;
        MutableComponent checkboxText = Utils.localize("gui.securitycraft:editModule.affectEveryone", new Object[0]);
        int length = this.font.width((FormattedText)checkboxText) + 24;
        this.inputField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, controlsStartX, this.height / 2 - 88, 107, 15, (Component)Component.empty()){

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (this.isFocused() && (keyCode == 257 || keyCode == 335)) {
                    EditModuleScreen.this.addPlayerButtonClicked(EditModuleScreen.this.addPlayerButton);
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        });
        this.addPlayerButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(controlsStartX, this.height / 2 - 68, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.add_player", new Object[0]), this::addPlayerButtonClicked, Button.DEFAULT_NARRATION));
        this.removePlayerButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(controlsStartX, this.height / 2 - 43, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.remove_player", new Object[0]), this::removePlayerButtonClicked, Button.DEFAULT_NARRATION));
        Button editTeamsButton = (Button)this.addRenderableWidget((GuiEventListener)new NonScrollableToggleComponentButton(controlsStartX, this.height / 2 - 18, controlsWidth, 20, i -> Utils.localize("gui.securitycraft:editModule.edit_teams", new Object[0]), 0, 2, this::editTeamsButtonClicked));
        this.copyButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(controlsStartX, this.height / 2 + 7, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::copyButtonClicked, Button.DEFAULT_NARRATION));
        this.pasteButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(controlsStartX, this.height / 2 + 32, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::pasteButtonClicked, Button.DEFAULT_NARRATION));
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(controlsStartX, this.height / 2 + 57, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::clearButtonClicked, Button.DEFAULT_NARRATION));
        this.playerList = (PlayerList)this.addRenderableWidget((GuiEventListener)new PlayerList(this.minecraft, 110, 165, this.height / 2 - 88, guiLeft + 10));
        this.teamList = (TeamList)this.addRenderableWidget((GuiEventListener)new TeamList(this.minecraft, editTeamsButton.getWidth(), 75, editTeamsButton.getY() + editTeamsButton.getHeight(), editTeamsButton.getX()));
        this.affectEveryPlayerCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(guiLeft + this.xSize / 2 - length / 2, guiTop + this.ySize - 25, 20, 20, (Component)checkboxText, this.module.hasTag() && this.module.getTag().getBoolean("affectEveryone"), newState -> this.module.getOrCreateTag().putBoolean("affectEveryone", newState.booleanValue()), 0x404040));
        this.teamList.active = false;
        editTeamsButton.active = !this.availableTeams.isEmpty();
        this.refreshFromNbt();
        this.updateButtonStates();
        this.inputField.setMaxLength(16);
        this.inputField.setFilter(s -> !s.contains(" "));
        this.inputField.setResponder(s -> {
            if (s.isEmpty()) {
                this.addPlayerButton.active = false;
            } else {
                if (this.module.hasTag()) {
                    for (int i = 1; i <= 50; ++i) {
                        if (!s.equals(this.module.getTag().getString("Player" + i))) continue;
                        this.addPlayerButton.active = false;
                        this.removePlayerButton.active = true;
                        this.playerList.setSelectedIndex(i - 1);
                        return;
                    }
                }
                this.addPlayerButton.active = true;
            }
            this.removePlayerButton.active = false;
            this.playerList.setSelectedIndex(-1);
        });
        this.setInitialFocus((GuiEventListener)this.inputField);
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SetListModuleData(this.module.getOrCreateTag())});
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawWordWrap(this.font, (FormattedText)this.editModule, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.editModule) / 2, this.topPos + 6, this.width, 0x404040);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.mouseReleased(mouseX, mouseY, button);
        }
        if (this.teamList != null) {
            this.teamList.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.inputField.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addPlayerButtonClicked(Button button) {
        if (this.inputField.getValue().isEmpty()) {
            return;
        }
        if (this.module.getTag() == null) {
            this.module.setTag(new CompoundTag());
        }
        for (int i = 1; i <= 50; ++i) {
            if (!this.module.getTag().contains("Player" + i) || !this.module.getTag().getString("Player" + i).equals(this.inputField.getValue())) continue;
            if (i == 9) {
                this.addPlayerButton.active = false;
            }
            return;
        }
        this.module.getTag().putString("Player" + this.getNextFreeSlot(this.module.getTag()), this.inputField.getValue());
        if (this.module.getTag() != null && this.module.getTag().contains("Player50")) {
            this.addPlayerButton.active = false;
        }
        this.inputField.setValue("");
        this.updateButtonStates();
    }

    private void editTeamsButtonClicked(Button button) {
        boolean buttonState;
        this.pasteButton.visible = this.clearButton.visible = (buttonState = ((ToggleComponentButton)button).getCurrentIndex() == 0);
        this.copyButton.visible = this.clearButton.visible;
        this.teamList.active = !buttonState;
    }

    private void removePlayerButtonClicked(Button button) {
        if (this.inputField.getValue().isEmpty()) {
            return;
        }
        if (this.module.getTag() == null) {
            this.module.setTag(new CompoundTag());
        }
        for (int i = 1; i <= 50; ++i) {
            if (!this.module.getTag().contains("Player" + i) || !this.module.getTag().getString("Player" + i).equals(this.inputField.getValue())) continue;
            this.module.getTag().remove("Player" + i);
            this.defragmentTag(this.module.getTag());
        }
        this.inputField.setValue("");
        this.updateButtonStates();
    }

    private void copyButtonClicked(Button button) {
        savedModule = this.module.getTag().copy();
        this.copyButton.active = false;
        this.updateButtonStates();
    }

    private void pasteButtonClicked(Button button) {
        this.module.setTag(savedModule.copy());
        this.updateButtonStates();
        this.refreshFromNbt();
    }

    private void clearButtonClicked(Button button) {
        this.module.setTag(new CompoundTag());
        this.inputField.setValue("");
        this.updateButtonStates(true);
        this.refreshFromNbt();
    }

    private void updateButtonStates() {
        this.updateButtonStates(false);
    }

    private void updateButtonStates(boolean cleared) {
        boolean tagIsConsideredEmpty;
        CompoundTag tag = this.module.getOrCreateTag();
        boolean bl = tagIsConsideredEmpty = tag.isEmpty() || tag.size() == 1 && tag.contains("affectEveryone");
        if (!cleared && tagIsConsideredEmpty) {
            this.addPlayerButton.active = false;
            this.removePlayerButton.active = false;
        } else {
            this.addPlayerButton.active = !tag.contains("Player50") && !this.inputField.getValue().isEmpty();
            this.removePlayerButton.active = !this.inputField.getValue().isEmpty();
        }
        this.copyButton.active = !tagIsConsideredEmpty && !tag.equals((Object)savedModule);
        this.pasteButton.active = savedModule != null && !savedModule.isEmpty() && !tag.equals((Object)savedModule);
        this.clearButton.active = !tagIsConsideredEmpty;
    }

    private void refreshFromNbt() {
        if (!this.module.hasTag()) {
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, false));
            this.affectEveryPlayerCheckbox.setSelected(false);
        } else {
            CompoundTag tag = this.module.getTag();
            List<String> teamNames = tag.getList("ListedTeams", 8).stream().filter(StringTag.class::isInstance).map(e -> ((StringTag)e).getAsString()).toList();
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, teamNames.contains(team.getName())));
            this.affectEveryPlayerCheckbox.setSelected(tag.getBoolean("affectEveryone"));
        }
    }

    private int getNextFreeSlot(CompoundTag tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.contains("Player" + i) && !tag.getString("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private void defragmentTag(CompoundTag tag) {
        ArrayDeque<Integer> freeIndices = new ArrayDeque<Integer>();
        for (int i = 1; i <= 50; ++i) {
            if (!tag.contains("Player" + i) || tag.getString("Player" + i).isEmpty()) {
                freeIndices.add(i);
                continue;
            }
            if (freeIndices.isEmpty()) continue;
            String player = tag.getString("Player" + i);
            int nextFreeIndex = (Integer)freeIndices.poll();
            tag.putString("Player" + nextFreeIndex, player);
            tag.remove("Player" + i);
            freeIndices.add(i);
        }
    }

    private void renderBox(BufferBuilder bufferBuilder, int min, int max, int slotTop, int slotBuffer, int borderColor) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.vertex((double)min, (double)(slotTop + slotBuffer + 2), 0.0).color(borderColor, borderColor, borderColor, 255).endVertex();
        bufferBuilder.vertex((double)max, (double)(slotTop + slotBuffer + 2), 0.0).color(borderColor, borderColor, borderColor, 255).endVertex();
        bufferBuilder.vertex((double)max, (double)(slotTop - 2), 0.0).color(borderColor, borderColor, borderColor, 255).endVertex();
        bufferBuilder.vertex((double)min, (double)(slotTop - 2), 0.0).color(borderColor, borderColor, borderColor, 255).endVertex();
        bufferBuilder.vertex((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).color(0, 0, 0, 255).endVertex();
        bufferBuilder.vertex((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).color(0, 0, 0, 255).endVertex();
        bufferBuilder.vertex((double)(max - 1), (double)(slotTop - 1), 0.0).color(0, 0, 0, 255).endVertex();
        bufferBuilder.vertex((double)(min + 1), (double)(slotTop - 1), 0.0).color(0, 0, 0, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.disableBlend();
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/edit_module.png");
        CONFIRM_SPRITE = new ResourceLocation("container/beacon/confirm");
        CANCEL_SPRITE = new ResourceLocation("container/beacon/cancel");
    }

    class NonScrollableToggleComponentButton
    extends ToggleComponentButton {
        public NonScrollableToggleComponentButton(int xPos, int yPos, int width, int height, IntFunction<Component> onValueChange, int initialValue, int toggleCount, Button.OnPress onPress) {
            super(xPos, yPos, width, height, onValueChange, initialValue, toggleCount, onPress);
        }

        @Override
        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return false;
        }
    }

    class PlayerList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private static final int LIST_LENGTH = 50;
        private int selectedIndex;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.selectedIndex = -1;
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.font);
            int height = 50 * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY) && mouseX < (double)(this.left + this.width - 6)) {
                int clickedIndex = (int)(mouseY - (double)this.top + (double)this.scrollDistance - (double)this.border) / 12;
                if (EditModuleScreen.this.module.hasTag() && EditModuleScreen.this.module.getTag().contains("Player" + (clickedIndex + 1))) {
                    this.selectedIndex = clickedIndex;
                    EditModuleScreen.this.inputField.setValue(EditModuleScreen.this.module.getTag().getString("Player" + (clickedIndex + 1)));
                }
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tessellator, int mouseX, int mouseY) {
            if (EditModuleScreen.this.module.hasTag()) {
                CompoundTag tag = EditModuleScreen.this.module.getTag();
                int baseY = this.top + this.border - (int)this.scrollDistance;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                int slotIndex = mouseListY / 12;
                if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 50 && mouseY >= this.top && mouseY <= this.bottom && tag.contains("Player" + (slotIndex + 1)) && !tag.getString("Player" + (slotIndex + 1)).isEmpty()) {
                    EditModuleScreen.this.renderBox(tessellator.getBuilder(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
                }
                if (this.selectedIndex >= 0) {
                    EditModuleScreen.this.renderBox(tessellator.getBuilder(), this.left, entryRight - 6, baseY + this.selectedIndex * 12, 8, 255);
                }
                for (int i = 0; i < 50; ++i) {
                    String name;
                    if (!tag.contains("Player" + (i + 1)) || (name = tag.getString("Player" + (i + 1))).isEmpty()) continue;
                    guiGraphics.drawString(EditModuleScreen.this.font, name, this.left - 2 + this.width / 2 - EditModuleScreen.this.font.width(name) / 2, relativeY + 12 * i, 0xC6C6C6, false);
                }
            }
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    class TeamList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private final int listLength;
        private int selectedIndex;
        private boolean active;

        public TeamList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.selectedIndex = -1;
            this.active = true;
            this.listLength = EditModuleScreen.this.availableTeams.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.font);
            int height = this.listLength * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex;
            if (this.active && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && slotIndex < this.listLength) {
                Minecraft mc = Minecraft.getInstance();
                double relativeMouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
                if (relativeMouseY >= (double)this.top && relativeMouseY <= (double)this.bottom) {
                    this.toggleTeam(EditModuleScreen.this.availableTeams.get(slotIndex));
                    EditModuleScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    return true;
                }
            }
            return false;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.active) {
                super.render(guiGraphics, mouseX, mouseY, partialTick);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
                int slotIndex = mouseListY / 12;
                if (slotIndex >= 0 && slotIndex < this.listLength && mouseX >= this.left && mouseX < this.right - 6 && mouseListY >= 0 && mouseY >= this.top && mouseY <= this.bottom) {
                    Component name = EditModuleScreen.this.availableTeams.get(slotIndex).getDisplayName();
                    int length = EditModuleScreen.this.font.width((FormattedText)name);
                    int baseY = this.top + this.border - (int)this.scrollDistance;
                    if (length >= this.width - 6) {
                        guiGraphics.renderTooltip(EditModuleScreen.this.font, name, this.left + 3, baseY + (12 * slotIndex + 12));
                    }
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tessellator, int mouseX, int mouseY) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                EditModuleScreen.this.renderBox(tessellator.getBuilder(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
            }
            for (int i = 0; i < this.listLength; ++i) {
                int yStart = relativeY + 12 * i;
                PlayerTeam team = EditModuleScreen.this.availableTeams.get(i);
                guiGraphics.drawString(EditModuleScreen.this.font, team.getDisplayName(), this.left + 15, yStart, 0xC6C6C6, false);
                guiGraphics.blitSprite(EditModuleScreen.this.teamsListedStatus.get(team) != false ? CONFIRM_SPRITE : CANCEL_SPRITE, this.left + 1, yStart - 3, 12, 12);
            }
        }

        private void toggleTeam(PlayerTeam teamToAdd) {
            ListTag listedTeams = new ListTag();
            EditModuleScreen.this.teamsListedStatus.put(teamToAdd, EditModuleScreen.this.teamsListedStatus.get(teamToAdd) == false);
            EditModuleScreen.this.teamsListedStatus.forEach((team, listed) -> {
                if (listed.booleanValue()) {
                    listedTeams.add((Object)StringTag.valueOf((String)team.getName()));
                }
            });
            EditModuleScreen.this.module.getOrCreateTag().put("ListedTeams", (Tag)listedTeams);
            EditModuleScreen.this.updateButtonStates();
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

