/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.KeycardHolderMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class ItemInventoryScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected ResourceLocation texture;

    protected ItemInventoryScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(this.texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public static class KeycardHolder
    extends ItemInventoryScreen<KeycardHolderMenu> {
        public KeycardHolder(KeycardHolderMenu menu, Inventory inventory, Component title) {
            super(menu, inventory, title);
            this.texture = new ResourceLocation("securitycraft", "textures/gui/container/keycard_holder.png");
            this.imageHeight = 133;
        }
    }

    public static class Briefcase
    extends ItemInventoryScreen<BriefcaseMenu> {
        public Briefcase(BriefcaseMenu menu, Inventory inventory, Component title) {
            super(menu, inventory, title);
            this.texture = new ResourceLocation("securitycraft", "textures/gui/container/briefcase_inventory.png");
        }
    }
}

